<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('password');
    protected $fillable = array('username', 'email', 'avatar', 'name', 'slug', 'ip', 'user_role', 'activated', 'remember', 'remember_token', 'is_fake', 'verified_on', 'active_on', 'confirmed', 'activated_at', 'published', 'published_on', 'last_login', 'blocked_on', 'article_id', 'software_id', 'is_employee', 'task_id', 'employee_hr_id', 'question_id', 'page_id', 'prefered_language');
    protected $visible = array('username', 'email', 'avatar', 'name', 'slug', 'ip', 'user_role', 'activated', 'remember', 'remember_token', 'is_fake', 'verified_on', 'active_on', 'confirmed', 'activated_at', 'published', 'published_on', 'last_login', 'blocked_on', 'article_id', 'software_id', 'is_employee', 'task_id', 'employee_hr_id', 'question_id', 'page_id', 'prefered_language');

    public function profile()
    {
        return $this->hasOne('App\Models\Profile');
    }

    public function address()
    {
        return $this->hasMany('App\Models\Address');
    }

    public function billing()
    {
        return $this->hasOne('App\Models\Billing');
    }

    public function shipping()
    {
        return $this->hasOne('App\Models\Shipping');
    }

    public function apikey()
    {
        return $this->hasMany('App\Models\ApiKeys');
    }

    public function article()
    {
        return $this->hasMany('App\Models\Article');
    }

    public function software()
    {
        return $this->hasMany('App\Models\Software');
    }

    public function tasks()
    {
        return $this->hasManyThrough('App\Models\Task');
    }

    public function hr()
    {
        return $this->hasOne('App\Models\User', 'id', 'employee_hr_id');
    }

    public function pages()
    {
        return $this->hasMany('App\Models\Page');
    }

}